<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require('vendor/fpdf/fpdf.php');

//Validar NIF
if (!isset($_POST['nif']) || empty($_POST['nif']) || strlen($_POST['nif']) !== 9 || !is_numeric($_POST['nif'])) {
    die("Erro: O NIF é obrigatório e deve ter 9 dígitos.");
}

// Criar pasta "consentimentos" se não existir
$pasta = "consentimentos/";
if (!is_dir($pasta)) {
    mkdir($pasta, 0777, true);
}

// Receber dados do formulário
$assinatura = $_POST['assinatura'];
$consentimento = $_POST['consentimento'];
$nif = $_POST['nif'];

// Gerar nome de ficheiro único
$nome_ficheiro = "consentimento_" . $nif . "_" . time() . ".pdf";
$caminho_pdf = $pasta . $nome_ficheiro;

// Guardar assinatura como imagem
$imagem_nome = "assinatura_" . time() . ".png";
$caminho_imagem = $pasta . $imagem_nome;
$assinatura = str_replace('data:image/png;base64,', '', $assinatura);
$assinatura = base64_decode($assinatura);
file_put_contents($caminho_imagem, $assinatura);

// Criar o PDF
$pdf = new FPDF();
$pdf->AddPage();
$pdf->AddFont('DejaVu','','DejaVuSans.php'); // Regular
$pdf->AddFont('DejaVu', 'B', 'DejaVuSans-Bold.php'); // Bold
$pdf->SetFont('DejaVu', '', 10);

// Adicionar logo
$pdf->Image('img/logo.png', 10, 10, 50);
$pdf->Ln(20);

// Título
$pdf->SetFont('DejaVu', 'B', 14);
$pdf->Cell(0, 7, utf8_decode('Consentimento para Tratamento de Dados Pessoais'), 0, 1, 'C');
$pdf->Ln(0);

// Corpo do texto
$pdf->SetFont('DejaVu', '', 10);
$texto = "Para os efeitos previstos no disposto no art.º 13.º do Regulamento Geral de Proteção de Dados (EU)2016/679 do P. E. e do Conselho de 27 de abril (RGPD) serve o presente documento para prestar o seu consentimento para o tratamento dos seus dados pessoais.\n\n";
$texto .= "No caso de o utente ser menor de 13 anos ou incapaz, caberá ao titular da responsabilidade parental ou da tutoria a junção ao processo administrativo do menor ou incapaz de documento comprovativo, nos termos legalmente admissíveis, dessa titularidade. Feita essa prova, cabe ao referido titular das responsabilidades parentais ou tutoria assinar o presente documento e dar o consentimento para o tratamento dos dados do menor ou incapaz, quando aplicável.\n\n";
$pdf->MultiCell(0, 5, utf8_decode($texto));
$pdf->Ln(0);

// Subtítulo 1
$pdf->SetFont('DejaVu', 'B', 12);
$pdf->Cell(0, 7, 'Recolha de dados pessoais', 0, 1, 'C');
$pdf->Ln(0);
// Corpo do texto
$pdf->SetFont('DejaVu', '', 10);
$texto = "A Medinova Lda preocupa-se em proteger a sua privacidade e ira recolher, processar e armazenar os seus dados pessoais, incluindo os, direta ou indiretamente, relacionados com a sua saúde, enquanto responsável pelo tratamento dos mesmos. No âmbito de algumas especialidades clínicas, a Medinova Lda poderá tratar os seus dados conjuntamente com outras entidades, enquanto corresponsáveis pelo tratamento.\n\n";
$pdf->MultiCell(0, 5, utf8_decode($texto));
$pdf->Ln(0);

// Subtítulo 2
$pdf->SetFont('DejaVu', 'B', 12);
$pdf->Cell(0, 7, 'Privacidade de dados do titular', 0, 1, 'C');
$pdf->Ln(0);
// Corpo do texto
$pdf->SetFont('DejaVu', '', 10);
$texto = "A Medinova Lda compromete-se a adotar as medidas de segurança necessárias para garantir a salvaguarda dos seus dados pessoais contra a sua eventual utilização abusiva ou contra o acesso não autorizado.\n\n";
$texto .= "Nos termos e para os efeitos do disposto nos artigos 13.Q a 22.Q do Regulamento Geral de Proteção de Dados (EU)2016/679 do P. E. e do Conselho de 27 de abril em vigor, e em consonância com a sua aplicação a nível nacional, tem direito a:\n\n";
$pdf->MultiCell(0, 5, utf8_decode($texto));
$pdf->Ln(0);

// Lista de artigos
$pdf->SetFont('DejaVu', '', 10);
$itens = [
    "Retirar o consentimento relativamente ao tratamento efetuado dos seus dados pessoais - verificadas as condições legalmente previstas;",
    
    "Opor-se a continuação do tratamento dos seus dados pessoais - verificadas as condições legalmente previstas;",
    
    "Solicitar ao responsável pelo tratamento dos dados pessoais o acesso aos mesmos, bem como a respetiva retificação ou apagamento, incluindo o exercício do 'direito a ser esquecido' - verificadas as condições legalmente previstas -devera exercer esse direito por escrito, através de dpo@medinov.pt",
    
    "Apresentar queixa a CNPD, obtendo, para o efeito, junto da Medinova Lda os contactos da mesma;",
    
    "Ser informado(a), a pedido, sobre as finalidades do tratamento, as categorias de dados envolvidos, a identidade dos destinatários a quem tenham sido divulgados e o período de conservação dos seus dados pessoais;",
    
    "Ser informado(a) sobre quais os dados pessoais em fase de tratamento e quaisquer informações disponíveis sobre a origem desses dados, por via eletrónica através de dpo@medinova.pt;"
];

$letra = 'a';
foreach ($itens as $item) {
    $pdf->MultiCell(0, 5, "$letra) " . utf8_decode($item));
    $pdf->Ln(4); // Pequeno espaço entre itens
    $letra++;
}

// Subtítulo 3
$pdf->SetFont('DejaVu', 'B', 12);
$pdf->Cell(0, 7, utf8_decode('Transmissão de dados a terceiros'), 0, 1, 'C');
$pdf->Ln(0);
// Corpo do texto
$pdf->SetFont('DejaVu', '', 10);
$texto = "Os seus dados poderão ser transmitidos a entidades subcontratadas para prestação de serviços, nos termos dos contratos celebrados com as mesmas, podendo ainda ser comunicados a entidades terceiras para as finalidades aqui previstas e para efeitos de cumprimento de obrigações legais, de uma deliberação da Comissão Nacional de Proteção de Dados ou de outra autoridade de controlo relevante, de uma ordem judicial, para proteção de interesses vitais dos clientes.\n\n";
$texto .= "Os dados relacionados com a sua saúde apenas serão tratados por ou sob a responsabilidade de profissionais obrigados a sigilo e na medida do necessário a prestação de cuidados de saúde, podendo ser comunicados aos seus familiares, apenas nas circunstâncias expressamente previstas na Lei em vigor.\n\n";
$texto .= "Caso pretenda que os serviços prestados pela Medinova Lda sejam abrangidos pelo seu seguro ou subsistema de saúde, quando aplicável, os seus dados pessoais, incluindo os dados de saúde relacionados com tais serviços, poderão ser comunicados a Companhia de Seguros ou ao Subsistema de saúde de que seja beneficiário, sendo que estes são obrigados a sigilo.\n\n";
$texto .= "lmporta ainda aduzir que, relativamente a prescrição medicamentosa eletrónica os seus dados pessoais serão transmitidos a ACSS - No âmbito do Sistema de Conferencia de Faturas de Medicamentos.\n\n";
$pdf->MultiCell(0, 5, utf8_decode($texto));
$pdf->Ln(0);

// Subtítulo 4
$pdf->SetFont('DejaVu', 'B', 12);
$pdf->Cell(0, 7, utf8_decode('Prazos para armazenamento de informações'), 0, 1, 'C');
$pdf->Ln(0);
// Corpo do texto
$pdf->SetFont('DejaVu', '', 10);
$texto = "Os dados pessoais necessários a prestação dos cuidados de saúde serão conservados nos termos da legislação aplicável ao arquivo da documentação hospitalar e pelos prazos aí definidos. Para obter mais informações sobre os termos do tratamento de dados pela Medinova Lda, por favor contactar o nosso Encarregado de Proteção de Dados, para o dpo@medinova.pt\n\n";
$pdf->MultiCell(0, 5, utf8_decode($texto));
$pdf->Ln(0);

$pdf->MultiCell(0, 5, "Eu, abaixo assinado, declaro que dou o meu consentimento para o tratamento dos meus dados pessoais.");
$pdf->Ln(5);
$pdf->Cell(0, 7, "Consentimento: " . $consentimento);
$pdf->Ln(5);
$pdf->Cell(0, 7, utf8_decode("Número de Contribuinte: ") . $nif);
$pdf->Ln(5);
$pdf->Cell(0, 10, "Assinatura:");
$pdf->Ln(5);

// Inserir a imagem da assinatura
$pdf->Image($caminho_imagem, 10, $pdf->GetY(), 80);
$pdf->Ln(20); // Adiciona espaço após a assinatura

// Adicionar a data
$data_atual = date("d-m-Y");
$pdf->Cell(0, 10, "Data: " . $data_atual);

// Guardar o PDF
$pdf->Output($caminho_pdf, "F");

// Redirecionar após submeter
header("Location: index.html");
exit();
?>
